package examples.messaging;

import javax.jms.*;
import javax.naming.InitialContext;

public class LogClient {

    public static void main(String[] args) throws Exception {
        // Initialize JNDI
        InitialContext ctx = new InitialContext(System.getProperties());

        // 1: Lookup connection factory        
        TopicConnectionFactory factory = 
            (TopicConnectionFactory) ctx.lookup("jms/TopicConnectionFactory");
        
        // 2: Use connection factory to create JMS connection
        TopicConnection connection = factory.createTopicConnection();
        
        // 3: Use connection to create a session
        TopicSession session = 
            connection.createTopicSession(false,Session.AUTO_ACKNOWLEDGE);
        
        // 4: Lookup destination 
        Topic topic = (Topic)ctx.lookup("jms/Topic");        
        
        // 5: Create a message publisher 
        TopicPublisher publisher = session.createPublisher(topic);

        // 6: Create and publish a message
        TextMessage msg = session.createTextMessage();
        msg.setText("This is a test message.");
        publisher.send(msg);
        
        // finish
        publisher.close();
        System.out.println("Message published. Please check application server's console to see the response from MDB.");
    }
}